/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.converters;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.oas.inflector.converters.ConversionException;
import io.swagger.oas.inflector.converters.Converter;
import io.swagger.oas.inflector.utils.ReflectionUtils;
import io.swagger.oas.inflector.validators.ValidationError;
import io.swagger.oas.inflector.validators.ValidationMessage;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConverter
extends ReflectionUtils
implements Converter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConverter.class);
    private Map<String, Schema> definitions;

    @Override
    public Object convert(List<String> value, Parameter parameter, Class<?> cls, Map<String, Schema> definitions, Iterator<Converter> chain) throws ConversionException {
        return this.coerceValue(value, parameter, cls);
    }

    @Override
    public Object convert(List<String> value, RequestBody body, Class<?> cls, Map<String, Schema> definitions, Iterator<Converter> chain) throws ConversionException {
        return this.coerceValue(value, body, cls);
    }

    @Override
    public Object convert(List<String> value, RequestBody body, Class<?> cls, Class<?> innerClass, Map<String, Schema> definitions, Iterator<Converter> chain) throws ConversionException {
        return this.coerceValue(value, body, cls, innerClass);
    }

    public Object coerceValue(List<String> arguments, RequestBody body, Class<?> cls) throws ConversionException {
        return this.coerceValue(arguments, body, cls, null);
    }

    public Object coerceValue(List<String> arguments, RequestBody body, Class<?> cls, Class<?> innerClass) throws ConversionException {
        block16: {
            block15: {
                if (arguments == null || arguments.size() == 0) {
                    return null;
                }
                LOGGER.debug("casting `" + arguments + "` to " + cls);
                if (!List.class.equals(cls)) break block15;
                if (this.isJson(arguments) && innerClass != null) {
                    ArrayList<Object> objects = new ArrayList<Object>();
                    for (String argument : arguments) {
                        String[] split;
                        for (String aSplit : split = argument.split("},")) {
                            try {
                                String object = aSplit.endsWith("}") ? aSplit : aSplit + "}";
                                objects.add(new ObjectMapper().readValue(object, innerClass));
                            }
                            catch (IOException e) {
                                LOGGER.error("error casting `" + arguments + "` to " + cls);
                            }
                        }
                    }
                    return objects;
                }
                if (body.getContent() == null) break block16;
                for (String mediaType : body.getContent().keySet()) {
                    MediaType media = (MediaType)body.getContent().get((Object)mediaType);
                    if (media.getSchema() == null) continue;
                    ArrayList output = new ArrayList();
                    if (media.getSchema() instanceof ArraySchema) {
                        ArraySchema arraySchema = (ArraySchema)media.getSchema();
                        Schema schema = arraySchema.getItems();
                    }
                    ArrayList<String> allStrings = new ArrayList<String>();
                    for (String argument : arguments) {
                        String[] split = argument.split(",");
                        List<String> strings = Arrays.asList(split);
                        if (strings.size() <= 0) continue;
                        allStrings.addAll(strings);
                    }
                    return allStrings;
                }
                break block16;
            }
            if (this.isJson(arguments)) {
                try {
                    return new ObjectMapper().readValue(arguments.get(0), cls);
                }
                catch (IOException e) {
                    LOGGER.error("error casting `" + arguments + "` to " + cls);
                }
            } else if (body.getContent() != null) {
                for (String mediaType : body.getContent().keySet()) {
                    MediaType media = (MediaType)body.getContent().get((Object)mediaType);
                    if (media.getSchema() == null) continue;
                    TypeFactory tf = Json.mapper().getTypeFactory();
                    return this.cast(arguments.get(0), media.getSchema(), tf.constructType(cls));
                }
            }
        }
        return null;
    }

    private boolean isJson(List<String> arguments) {
        boolean isJson = false;
        try {
            ObjectMapper mapper = new ObjectMapper();
            for (String argument : arguments) {
                mapper.readTree(argument);
                isJson = true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return isJson;
    }

    public Object coerceValue(List<String> arguments, Parameter parameter, Class<?> cls) throws ConversionException {
        if (arguments == null || arguments.size() == 0) {
            return null;
        }
        LOGGER.debug("casting `" + arguments + "` to " + cls);
        if (List.class.equals(cls)) {
            if (parameter.getSchema() != null) {
                ArrayList<Object> output = new ArrayList<Object>();
                if (parameter.getSchema() instanceof ArraySchema) {
                    ArraySchema arraySchema = (ArraySchema)parameter.getSchema();
                    Schema inner = arraySchema.getItems();
                    QueryParameter innerParam = new QueryParameter();
                    innerParam.setSchema(inner);
                    JavaType innerClass = this.getTypeFromParameter((Parameter)innerParam, this.definitions);
                    for (String obj : arguments) {
                        String[] parts = new String[]{};
                        if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle()) && !StringUtils.isEmpty((CharSequence)obj) && !parameter.getExplode().booleanValue()) {
                            parts = obj.split(",");
                        }
                        if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)parameter.getStyle()) && !StringUtils.isEmpty((CharSequence)obj)) {
                            parts = obj.split("|");
                        }
                        if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)parameter.getStyle()) && !StringUtils.isEmpty((CharSequence)obj)) {
                            parts = obj.split(" ");
                        }
                        if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle()) && !StringUtils.isEmpty((CharSequence)obj) && parameter.getExplode().booleanValue()) {
                            parts = new String[]{obj};
                        }
                        for (String p : parts) {
                            Object ob = this.cast(p, inner, innerClass);
                            if (ob == null) continue;
                            output.add(ob);
                        }
                    }
                }
                return output;
            }
        } else if (parameter.getSchema() != null) {
            TypeFactory tf = Json.mapper().getTypeFactory();
            return this.cast(arguments.get(0), parameter.getSchema(), tf.constructType(cls));
        }
        return null;
    }

    public Object cast(List<String> arguments, Parameter parameter, JavaType javaType, Map<String, Schema> definitions) throws ConversionException {
        if (arguments == null || arguments.size() == 0) {
            return null;
        }
        Class cls = javaType.getRawClass();
        LOGGER.debug("converting array `" + arguments + "` to `" + cls + "`");
        if (javaType.isArrayType()) {
            if (parameter.getSchema() != null) {
                ArraySchema arraySchema;
                ArrayList<Object> output = new ArrayList<Object>();
                if (parameter.getSchema() instanceof ArraySchema && (arraySchema = (ArraySchema)parameter.getSchema()).getItems() != null) {
                    Schema inner = arraySchema.getItems();
                    Parameter innerParam = new QueryParameter().schema(inner);
                    JavaType innerClass = this.getTypeFromParameter(innerParam, definitions);
                    for (String obj : arguments) {
                        String[] parts = new String[]{};
                        CSVFormat format = null;
                        if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle()) && !StringUtils.isEmpty((CharSequence)obj) && !parameter.getExplode().booleanValue()) {
                            format = CSVFormat.DEFAULT;
                        } else if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)parameter.getStyle()) && !StringUtils.isEmpty((CharSequence)obj)) {
                            format = CSVFormat.newFormat((char)'|').withQuote('\"');
                        } else if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)parameter.getStyle()) && !StringUtils.isEmpty((CharSequence)obj)) {
                            format = CSVFormat.newFormat((char)' ').withQuote('\"');
                        }
                        if (format != null) {
                            try {
                                for (CSVRecord record : CSVParser.parse((String)obj, (CSVFormat)format).getRecords()) {
                                    ArrayList it = new ArrayList();
                                    Iterator x = record.iterator();
                                    while (x.hasNext()) {
                                        it.add(x.next());
                                    }
                                    parts = it.toArray(new String[it.size()]);
                                }
                            }
                            catch (IOException iOException) {}
                        } else {
                            parts = new String[]{obj};
                        }
                        for (String p : parts) {
                            Object ob = this.cast(p, inner, innerClass);
                            if (ob == null) continue;
                            output.add(ob);
                        }
                    }
                    return output;
                }
            }
        } else if (parameter != null) {
            return this.cast(arguments.get(0), parameter.getSchema(), javaType);
        }
        return null;
    }

    public Object cast(String argument, Schema property, JavaType javaType) throws ConversionException {
        if (argument == null || javaType == null) {
            return null;
        }
        Class cls = javaType.getRawClass();
        LOGGER.debug("coercing `" + argument + "` to `" + cls + "`");
        try {
            if (Integer.class.equals((Object)cls)) {
                return Integer.parseInt(argument);
            }
            if (Long.class.equals((Object)cls)) {
                return Long.parseLong(argument);
            }
            if (Float.class.equals((Object)cls)) {
                return Float.valueOf(Float.parseFloat(argument));
            }
            if (Double.class.equals((Object)cls)) {
                return Double.parseDouble(argument);
            }
            if (String.class.equals((Object)cls)) {
                return argument;
            }
            if (Boolean.class.equals((Object)cls)) {
                if ("1".equals(argument)) {
                    return Boolean.TRUE;
                }
                if ("0".equals(argument)) {
                    return Boolean.FALSE;
                }
                return Boolean.parseBoolean(argument);
            }
            if (UUID.class.equals((Object)cls)) {
                return UUID.fromString(argument);
            }
            if (LocalDate.class.equals((Object)cls)) {
                return LocalDate.parse((String)argument);
            }
            if (DateTime.class.equals((Object)cls)) {
                return DateTime.parse((String)argument);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.debug("couldn't coerce `" + argument + "` to type " + cls);
            throw new ConversionException().message(new ValidationMessage().code(ValidationError.INVALID_FORMAT).message("couldn't convert `" + argument + "` to type `" + cls + "`"));
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("couldn't coerce `" + argument + "` to type " + cls);
            throw new ConversionException().message(new ValidationMessage().code(ValidationError.INVALID_FORMAT).message("couldn't convert `" + argument + "` to type `" + cls + "`"));
        }
        return null;
    }
}

