<?
include_once("config.php");
		class Objective extends Fly5 {
			function fetchLastChoice($a)
			{
				return query("select *, a.no as choiceno from obj_choice a
					join obj_option on obj_option.no = a.optionno
					join objective on objective.no = obj_option.objectiveno
					where objective.name = :objective 
					order by a.choicetime desc limit 1", $a)[0];
			}
			
				function execute(&$view, $path, $args)
				{
						$a = $_REQUEST;
						switch($path) {
						case "Objective/api/fetchLastChoice":
								$result = $this->fetchLastChoice($a);
								break;
						case "Objective/api/fetchRequest":
								$result = $this->fetchRequest($a);
								break;
						case "Objective/api/listChoices":
								$result = $this->listChoices($a);
								break;
						case "Objective/api/searchChoices":
								$result = $this->searchChoices($a);
								break;
						case "Objective/api/cancelChoice":
								$result = $this->cancelChoice($a);
								break;
						case "Objective/api/updateSetting":
								$result = $this->updateSetting($a);
								break;
						case "Objective/api/insertExperience":
								$result = $this->insertExperience($a); 
								break;
						case "Objective/api/listExperience":
								$result = $this->listExperience($a);
								break;
						case "Objective/api/updateRequest":
								$result = $this->updateRequest($a);
								break;
						case "Objective/api/fetchOptionList":
								$result = $this->fetchOptionList($a);
								break;
						case "Objective/api/createOption":
								$result = $this->createOption($a);
								break;
						case "Objective/api/updateOption":
								$result = $this->updateOption($a);
								break;
						case "Objective/api/deleteOption":
								$result = $this->deleteOption($a);
								break;
						case "Objective/api/choose":
								$result = $this->chooseOption($a);
								break;
						case "Objective/api/getCategoryName":
								$result = $this->getCategoryName($a);
								break;
						default:
								$view = "$path.pug";
								return;
						}
						reply_json($result);
				}
				function chooseOption($a)
				{
						/*
						$rows = query("select *, obj_option.no as optionno from obj_option, objective
								where
										objective.no=objectiveno and
										objective.name=:objective and obj_option.content=:option", $a);
						*/
						$rows = query("select *, obj_option.no as optionno from obj_option
								left join objective on objective.no=objectiveno
								where
										obj_option.content=:option and hid=:hid", $a);
						$option = $rows[0];
						if(!$option)
								throw new Exception("잘못된 옵션 : $a[objective].$a[option]");

						$rows = query("select * from uis.ocs_patient where chartid=:chartid", $a);
						$patient = $rows[0];
						if(!$patient)
								throw new Exception("잘못된 환자 : $a[chartid]");

						$a[optionno] = $option[optionno];
						$a[patientno] = $patient[no];
						query("insert obj_choice
										(optionno, patientno, param1, param2)
								values
										(:optionno, :patientno, :param1, :param2)", $a);
						echo "ok";
				}

				function cancelChoice($a){
					
					$rows = query("update obj_choice set checked=-1 , checktime=now() where no=:obj_no", $a);
					return $rows;	
				}
				function listChoices($a){
					
					$all = query("select *, o.category category, a.last_room last_room, a.last_bedno last_bedno, a.chartid chartid, a.name as patientname, obj_option.content content, obj_choice.choicetime choicetime, o.name as objective, obj_choice.no as obj_no
									from objective o
									left join obj_option on objectiveno=o.no
									left join obj_choice on optionno=obj_option.no
									join uis.ocs_patient a on patientno=a.no
									where
											o.hid=:hid 
											and o.category=:category
									order by obj_no desc
							", $a);
					
					return $all;
				}
				function searchChoices($a){
					
						if($a[category] && $a[category] != 'all')
							$category = " and o.category=:category ";
						
						if($a[selectOption] && $a[selectOption] != '전체')
							$selectOption = " and o.name=:selectOption ";
						if($a[startDate])
							$sdate = " and date_format(choicetime,'%Y-%m-%d') >= :startDate";
						if($a[endDate])
							$edate = " and date_format(choicetime,'%Y-%m-%d') <= :endDate";
						
						$all = query("select *, o.category category, a.last_room last_room, a.last_bedno last_bedno, a.chartid chartid, a.name patientname, obj_option.content content, obj_choice.choicetime choicetime, o.name as objective, obj_choice.no as obj_no
								from objective o
								left join obj_option on objectiveno=o.no
								left join obj_choice on optionno=obj_option.no
								join uis.ocs_patient a on patientno=a.no
								where
										o.hid=:hid
										$category $selectOption $sdate $edate
								order by obj_no	desc
									
						", $a);
				
						return $all;
						
				}
						
				function fetchRequest($a){
					 $rows ='';
					 if( $a[checked]!=='선택'){
						 $checked = " and checked=:checked";
					 }
					 if( $a[ward]!=='전체'){
						 $ward = " and ward=:ward";
					 }
					 if( $a[listNum]!=='전체보기'){
						 $list = " limit $a[listNum]";
					 }
					 $rows =  query("select *, w.ward as ward, a.last_room last_room, a.last_bedno last_bedno, a.chartid chartid, b.param1 as param1 , a.name as patientname, o.name as objective, b.no as requestno
								from objective o
								left join obj_option on objectiveno=o.no
								left join obj_choice b on optionno=obj_option.no
								join uis.ocs_patient a on patientno=a.no
								left join wardmap w on a.last_room = w.room and a.last_bedno = w.bedno 
								where o.hid=:hid and o.category=:category $checked $ward order by b.checked , b.choicetime desc $list", $a);
					 
					  return $rows;

				}	

				function updateRequest($a){

					$rows = query("update obj_choice set checked=1 , checktime=now() where no=:requestno", $a);
					return $rows;	
				}

				function fetchOptionList($a){
						$rows =  query("select a.*, b.* from objective as a
								left join obj_option as b on a.no = b.objectiveno
								where a.name=:objective order by b.no", $a);
						return $rows;
				}
				function createOption($a){
						$check = query("select count(*) as cnt from obj_option where content=:content" , $a);
						if($check[0][cnt]!=='1'){
							$rows = query("insert into obj_option(objectiveno,content,memo) values((select no from objective where name =:objective),:content,:memo)", $a);
							return "추가 되었습니다.";
						}
						return "중복된 값으로 추가할수 없습니다.";
				}
				function updateOption($a){
						$check = query("select count(*) as cnt from obj_option where content=:uptContent" , $a);
						if($check[0][cnt]!=='1'){
							$rows = query("update obj_option set content=:uptContent where content=:content", $a);
							return "수정 되었습니다.";
						}
						if($check[0][cnt]==='1')						
							return "중복된 값으로 수정할수 없습니다.";
				}
				function deleteOption($a){
						$rows = query("delete from obj_option where objectiveno=(select no from objective where name =:objective) and content=:content" , $a);
						return $rows;
				}

				function updateSetting($a){
					$rows = query("update objective set name=:name, acceptStartDate=:acceptStartDate, acceptEndDate=:acceptEndDate, acceptPeople=:acceptPeople  where category=:category and enabled=1", $a);
					return $rows;	
				}
				function insertExperience($a){
					$rows = query("update objective set enabled=0 where category=:category and enabled=1", $a);
					
					$insert = query("insert into objective(name,creationtime,hid,category,acceptStartDate,acceptEndDate,acceptPeople) values(:name,now(),:hid,:category,:acceptStartDate,:acceptEndDate,:acceptPeople)",$a);	
				
					return $insert;
				}
				function listExperience($a){
					
					//select 항목
					$objective = query("select * from objective where category=:category and enabled=1",$a);
					return $objective; 
				}
				
				
				function choices(&$view)
				{
						$view = 'Objective/choices.pug';
						$a = $_REQUEST;
						if(!$a[hid])
								$a[hid] = $_COOKIE[hid];
						//print_r($a);die();
						if($a[category] && $a[category] != 'all')
								$category = " and o.category=:category ";
						$all = query("select *, o.category category, a.last_room last_room, a.last_bedno last_bedno, a.chartid chartid, a.name patientname, obj_option.content content, obj_choice.choicetime choicetime, o.name as objective, obj_choice.no as obj_no
								from objective o
								left join obj_option on objectiveno=o.no
								left join obj_choice on optionno=obj_option.no
								join uis.ocs_patient a on patientno=a.no
								where
										o.hid=:hid
										$category
								order by choicetime desc
						", $a);
						
						//select 항목
						$objective = query("select * from objective where category=:category and enabled=1",$a);

						return array(
								category=>$a[category],
								choices=>$all,
								objective=>$objective,
						);
				}

				function options(&$view)
				{
						$view = 'Objective/options.pug';
						$a = $_REQUEST;
						if(!$a[hid])
								$a[hid] = $_COOKIE[hid];
						//print_r($a);die();

						if($a[objective] && $a[objective] != 'all')
								$objective = " and a.name=:objective ";

						$all = query("select a.*, b.* from objective as a
								left join obj_option as b on a.no = b.objectiveno
								where a.name=:objective order by b.no ", $a);

						return array(
								objective=>$a[objective],
								options=>$all,
						);
				}

				function requests(&$view)
				{
						$view = 'Objective/requests.pug';
						$a = $_REQUEST;
						if(!$a[hid])
								$a[hid] = $_COOKIE[hid];
						//print_r($a);die();
						if($a[category] && $a[category] != 'all')
								$category = " and o.category=:category ";
						$all = query("select *, w.ward as ward, a.last_room last_room, a.last_bedno last_bedno, b.param1 as param1, a.name as patientname, o.name as objective, b.no as requestno
								from objective o
								left join obj_option on objectiveno=o.no
								left join obj_choice b on optionno=obj_option.no
								join uis.ocs_patient a on patientno=a.no
								left join wardmap w on a.last_room = w.room and a.last_bedno = w.bedno 
								where
										o.hid=:hid
										$category  
								order by b.checked, b.choicetime desc limit 100
						", $a);
						
						$selectWard = query("select * from s4ward ",$a);
						
						return array(
								category=>$a[category],
								requests=>$all,
								selectWard=>$selectWard,
						);
				}
				
				function getCategoryName($a){
					$q = query("select name from objective where category=:category",$a);
					$categoryNm = $q[0];
					return $categoryNm; 
				}


				function __construct()
				{
					$this->hid = "IM39";
				}
		}
