<?
	include_once("config.php");
	class Cms extends Fly5 {
		function contentLocalPath($dir)
		{
			$hid = $this->hid;
			$dir = "/mod/web/new/contents/$hid/$dir";//$b[localpath]/";
			if ($dir[strlen($dir)-1] != '/')
				$dir .= '/';
			return $dir;
		}
		function fetchContent($localpath, $filename)
		{
			$dir = $this->contentLocalPath($localpath);
			$note = @file_get_contents($dir.$filename.'.note');
			if (!$note)
				$note = "";
			$hid = $this->hid;
			$c = array(
				title=>substr($filename, 0, strlen($f)-4),
				filename=>$filename,
				path=>"/s4-contents/$hid/$localpath/$filename",
				//notefilename=>$dir.$filename.'.note',
				note=>$note,
			);
			return $c;
		}
		function fetchContents($a)
		{
			$result = array();
			$rows = query("select * from s4barn where hid=:hid and name=:name", $a);
			$b = $rows[0];
			$dir = $this->contentLocalPath($b[localpath]);
			@mkdir($dir, 0777, true);
			$files = scandir($dir);
			$result = array();
			foreach($files as $f) {
				if($f[0] == '.' || $f[0] == '_')
					continue;
				$ext = strtolower(pathinfo($f, PATHINFO_EXTENSION));
				if (in_array($ext, array('note', 'ini')))
					continue;
				if(is_dir($dir.$f))
					continue;
				$c = $this->fetchContent($b[localpath], $f);
				array_push($result, $c);
			}
			return $result;
		}
		function fetchFiles($a)
		{
			$result = array();
			$rows = query("select * from s4barn where hid=:hid and name=:name", $a);
			$b = $rows[0];
			$dir = $this->contentLocalPath($b[localpath]);
			@mkdir($dir, 0777, true);
			$files = scandir($dir);
			sort($files);
			$result = array();
			foreach($files as $f) {
				if($f[0] == '.' || $f[0] == '_')
					continue;
				if(is_dir($dir.$f))
					continue;
				array_push($result, $f);
			}
			return $result;
		}
		function execute(&$view, $path, $args)
		{
			$a = $_REQUEST;
			switch($path) {
			case "Cms/api/fetchContents":
				$result = $this->fetchContents($_REQUEST);
				break;
			case "Cms/api/fetchFiles":
				$result = $this->fetchFiles($_REQUEST);
				break;
			case "Cms/api/fetchBarns":
				$result = $this->fetchBarns($_REQUEST[hid]);
				break;

			case "Cms/api/putMeal":
				query("update meal set menu=:menu
					where no=:mealno and dietno=:dietno", $a);
					$result = 'ok';
				break;
			case "Cms/api/upload":
				$this->storeFiles($_REQUEST);
				$result = 'ok';
				break;
			case "Cms/api/delete":
				$this->deleteFile($_REQUEST);
				$result = 'ok';
				break;
			case "Cms/api/rename":
				$this->renameContents($_REQUEST);
				$result = 'ok';
				break;
			case "Cms/api/writeNote":
				$this->writeNote($_REQUEST);
				$result = 'ok';
				break;
			default:
				$view = "$path.pug";
				return;
			}
			reply_json($result);
		}
		function deleteFile($a)
		{
			$rows = query("select * from s4barn where no=:barnno", $a);
			$barn = $rows[0];
			$dir = $this->contentLocalPath($barn[localpath]);
			unlink($dir.$a[filename]);
		}
		function writeNote($a)
		{
			$rows = query("select * from s4barn where no=:barnno", $a);
			$barn = $rows[0];
			$dir = $this->contentLocalPath($barn[localpath]);
			file_put_contents($dir.$a[filename].'.note', $a[note]);
			return $this->fetchContent($barn[localpath], $a[filename]);
		}
		function renameContents($a)
		{
			$rows = query("select * from s4barn where no=:barnno", $a);
			$barn = $rows[0];
			$dir = $this->contentLocalPath($barn[localpath]);
			$ext = pathinfo($a[old_filename], PATHINFO_EXTENSION);
			$newfn = $dir.$a[new_filename].".".$ext;
			if(file_exists($newfn))
				die("이미 존재하는 파일명");
			
			$oldfn = $dir.$a[old_filename];
			rename($oldfn, $newfn);
			rename($oldfn.".note", $newfn.".note");
			return $this->fetchContent($barn[localpath], $newfn);
		}
		function storeFiles($a)
		{
			$rows = query("select * from s4barn where no=:barnno", $a);
			$barn = $rows[0];
			$dir = $this->contentLocalPath($barn[localpath]);
			@mkdir($dir, 0777, true);
			$files = $_FILES[files];
			$count = count($files[name]);
			for($i = 0; $i < $count; $i++)
			{
				if(!move_uploaded_file($files[tmp_name][$i], $dir.$files[name][$i]))
					throw new Exception($files[name][$i]." upload error");
			}
		}
		function fetchBarns($hid)
		{
			$rows = query("select * from s4barn");
			return $rows;
		}
		function main(&$view)
		{
			$view = 'Cms/main.pug';
			return array(
				barns=>$this->fetchBarns($this->hid),
				files=>[],
			);
		}
		function mainProto(&$view) 
		{
			$view = "Cms/main-proto.pug";
			return $this->main($view);
		}
		function __construct()
		{
			$this->hid = "IM39";
		}
	}
?>