/*
 * A JavaScript implementation of the Secure Hash Algorithm, SHA-1, as defined
 * in FIPS 180-1
 * Version 2.2 Copyright Paul Johnston 2000 - 2009.
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for details.
 */

/*
 * Configurable variables. You may need to tweak these to be compatible with
 * the server-side, but the defaults work in most cases.
 */
var hexcase = 0; /* hex output format. 0 - lowercase; 1 - uppercase */
var b64pad = ""; /* base-64 pad character. "=" for strict RFC compliance */

/*
 * These are the functions you'll usually want to call They take string
 * arguments and return either hex or base-64 encoded strings
 */
function hex_mysql(s) {
	return ("*"+rstr2hex(rstr_sha1(rstr_sha1(str2rstr_utf8(s))))).toUpperCase();
}
function hex_sha1(s) {
	return rstr2hex(rstr_sha1(str2rstr_utf8(s)));
}
function b64_sha1(s) {
	return rstr2b64(rstr_sha1(str2rstr_utf8(s)));
}
function any_sha1(s, e) {
	return rstr2any(rstr_sha1(str2rstr_utf8(s)), e);
}
function hex_hmac_sha1(k, d) {
	return rstr2hex(rstr_hmac_sha1(str2rstr_utf8(k), str2rstr_utf8(d)));
}
function b64_hmac_sha1(k, d) {
	return rstr2b64(rstr_hmac_sha1(str2rstr_utf8(k), str2rstr_utf8(d)));
}
function any_hmac_sha1(k, d, e) {
	return rstr2any(rstr_hmac_sha1(str2rstr_utf8(k), str2rstr_utf8(d)), e);
}

/*
 * Perform a simple self-test to see if the VM is working
 */
function sha1_vm_test() {
	return hex_sha1("abc").toLowerCase() == "a9993e364706816aba3e25717850c26c9cd0d89d";
}

/*
 * Calculate the SHA1 of a raw string
 */
function rstr_sha1(s) {
	return binb2rstr(binb_sha1(rstr2binb(s), s.length * 8));
}

/*
 * Calculate the HMAC-SHA1 of a key and some data (raw strings)
 */
function rstr_hmac_sha1(key, data) {
	var bkey = rstr2binb(key);
	if (bkey.length > 16)
		bkey = binb_sha1(bkey, key.length * 8);

	var ipad = Array(16), opad = Array(16);
	for ( var i = 0; i < 16; i++) {
		ipad[i] = bkey[i] ^ 0x36363636;
		opad[i] = bkey[i] ^ 0x5C5C5C5C;
	}

	var hash = binb_sha1(ipad.concat(rstr2binb(data)), 512 + data.length * 8);
	return binb2rstr(binb_sha1(opad.concat(hash), 512 + 160));
}

/*
 * Convert a raw string to a hex string
 */
function rstr2hex(input) {
	try {
		hexcase
	} catch (e) {
		hexcase = 0;
	}
	var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
	var output = "";
	var x;
	for ( var i = 0; i < input.length; i++) {
		x = input.charCodeAt(i);
		output += hex_tab.charAt((x >>> 4) & 0x0F) + hex_tab.charAt(x & 0x0F);
	}
	return output;
}

/*
 * Convert a raw string to a base-64 string
 */
function rstr2b64(input) {
	try {
		b64pad
	} catch (e) {
		b64pad = '';
	}
	var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	var output = "";
	var len = input.length;
	for ( var i = 0; i < len; i += 3) {
		var triplet = (input.charCodeAt(i) << 16)
				| (i + 1 < len ? input.charCodeAt(i + 1) << 8 : 0)
				| (i + 2 < len ? input.charCodeAt(i + 2) : 0);
		for ( var j = 0; j < 4; j++) {
			if (i * 8 + j * 6 > input.length * 8)
				output += b64pad;
			else
				output += tab.charAt((triplet >>> 6 * (3 - j)) & 0x3F);
		}
	}
	return output;
}

/*
 * Convert a raw string to an arbitrary string encoding
 */
function rstr2any(input, encoding) {
	var divisor = encoding.length;
	var remainders = Array();
	var i, q, x, quotient;

	/* Convert to an array of 16-bit big-endian values, forming the dividend */
	var dividend = Array(Math.ceil(input.length / 2));
	for (i = 0; i < dividend.length; i++) {
		dividend[i] = (input.charCodeAt(i * 2) << 8)
				| input.charCodeAt(i * 2 + 1);
	}

	/*
	 * Repeatedly perform a long division. The binary array forms the dividend,
	 * the length of the encoding is the divisor. Once computed, the quotient
	 * forms the dividend for the next step. We stop when the dividend is zero.
	 * All remainders are stored for later use.
	 */
	while (dividend.length > 0) {
		quotient = Array();
		x = 0;
		for (i = 0; i < dividend.length; i++) {
			x = (x << 16) + dividend[i];
			q = Math.floor(x / divisor);
			x -= q * divisor;
			if (quotient.length > 0 || q > 0)
				quotient[quotient.length] = q;
		}
		remainders[remainders.length] = x;
		dividend = quotient;
	}

	/* Convert the remainders to the output string */
	var output = "";
	for (i = remainders.length - 1; i >= 0; i--)
		output += encoding.charAt(remainders[i]);

	/* Append leading zero equivalents */
	var full_length = Math.ceil(input.length * 8
			/ (Math.log(encoding.length) / Math.log(2)))
	for (i = output.length; i < full_length; i++)
		output = encoding[0] + output;

	return output;
}

/*
 * Encode a string as utf-8. For efficiency, this assumes the input is valid
 * utf-16.
 */
function str2rstr_utf8(input) {
	var output = "";
	var i = -1;
	var x, y;

	while (++i < input.length) {
		/* Decode utf-16 surrogate pairs */
		x = input.charCodeAt(i);
		y = i + 1 < input.length ? input.charCodeAt(i + 1) : 0;
		if (0xD800 <= x && x <= 0xDBFF && 0xDC00 <= y && y <= 0xDFFF) {
			x = 0x10000 + ((x & 0x03FF) << 10) + (y & 0x03FF);
			i++;
		}

		/* Encode output as utf-8 */
		if (x <= 0x7F)
			output += String.fromCharCode(x);
		else if (x <= 0x7FF)
			output += String.fromCharCode(0xC0 | ((x >>> 6) & 0x1F),
					0x80 | (x & 0x3F));
		else if (x <= 0xFFFF)
			output += String.fromCharCode(0xE0 | ((x >>> 12) & 0x0F),
					0x80 | ((x >>> 6) & 0x3F), 0x80 | (x & 0x3F));
		else if (x <= 0x1FFFFF)
			output += String.fromCharCode(0xF0 | ((x >>> 18) & 0x07),
					0x80 | ((x >>> 12) & 0x3F), 0x80 | ((x >>> 6) & 0x3F),
					0x80 | (x & 0x3F));
	}
	return output;
}

/*
 * Encode a string as utf-16
 */
function str2rstr_utf16le(input) {
	var output = "";
	for ( var i = 0; i < input.length; i++)
		output += String.fromCharCode(input.charCodeAt(i) & 0xFF, (input
				.charCodeAt(i) >>> 8) & 0xFF);
	return output;
}

function str2rstr_utf16be(input) {
	var output = "";
	for ( var i = 0; i < input.length; i++)
		output += String.fromCharCode((input.charCodeAt(i) >>> 8) & 0xFF, input
				.charCodeAt(i) & 0xFF);
	return output;
}

/*
 * Convert a raw string to an array of big-endian words Characters >255 have
 * their high-byte silently ignored.
 */
function rstr2binb(input) {
	var output = Array(input.length >> 2);
	for ( var i = 0; i < output.length; i++)
		output[i] = 0;
	for ( var i = 0; i < input.length * 8; i += 8)
		output[i >> 5] |= (input.charCodeAt(i / 8) & 0xFF) << (24 - i % 32);
	return output;
}

/*
 * Convert an array of big-endian words to a string
 */
function binb2rstr(input) {
	var output = "";
	for ( var i = 0; i < input.length * 32; i += 8)
		output += String.fromCharCode((input[i >> 5] >>> (24 - i % 32)) & 0xFF);
	return output;
}

/*
 * Calculate the SHA-1 of an array of big-endian words, and a bit length
 */
function binb_sha1(x, len) {
	/* append padding */
	x[len >> 5] |= 0x80 << (24 - len % 32);
	x[((len + 64 >> 9) << 4) + 15] = len;

	var w = Array(80);
	var a = 1732584193;
	var b = -271733879;
	var c = -1732584194;
	var d = 271733878;
	var e = -1009589776;

	for ( var i = 0; i < x.length; i += 16) {
		var olda = a;
		var oldb = b;
		var oldc = c;
		var oldd = d;
		var olde = e;

		for ( var j = 0; j < 80; j++) {
			if (j < 16)
				w[j] = x[i + j];
			else
				w[j] = bit_rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1);
			var t = safe_add(safe_add(bit_rol(a, 5), sha1_ft(j, b, c, d)),
					safe_add(safe_add(e, w[j]), sha1_kt(j)));
			e = d;
			d = c;
			c = bit_rol(b, 30);
			b = a;
			a = t;
		}

		a = safe_add(a, olda);
		b = safe_add(b, oldb);
		c = safe_add(c, oldc);
		d = safe_add(d, oldd);
		e = safe_add(e, olde);
	}
	return Array(a, b, c, d, e);

}

/*
 * Perform the appropriate triplet combination function for the current
 * iteration
 */
function sha1_ft(t, b, c, d) {
	if (t < 20)
		return (b & c) | ((~b) & d);
	if (t < 40)
		return b ^ c ^ d;
	if (t < 60)
		return (b & c) | (b & d) | (c & d);
	return b ^ c ^ d;
}

/*
 * Determine the appropriate additive constant for the current iteration
 */
function sha1_kt(t) {
	return (t < 20) ? 1518500249 : (t < 40) ? 1859775393
			: (t < 60) ? -1894007588 : -899497514;
}

/*
 * Add integers, wrapping at 2^32. This uses 16-bit operations internally to
 * work around bugs in some JS interpreters.
 */
function safe_add(x, y) {
	var lsw = (x & 0xFFFF) + (y & 0xFFFF);
	var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
	return (msw << 16) | (lsw & 0xFFFF);
}

/*
 * Bitwise rotate a 32-bit number to the left.
 */
function bit_rol(num, cnt) {
	return (num << cnt) | (num >>> (32 - cnt));
}


function getCookie (name, def) {
	name = encodeURIComponent(name);
	var dcookie = document.cookie;
	var cname = name + "=";
	var clen = dcookie.length;
	var cbegin = 0;
	while (cbegin < clen) {
		var vbegin = cbegin + cname.length;
			if (dcookie.substring(cbegin, vbegin) == cname) {
				var vend = dcookie.indexOf (";", vbegin);
				if (vend == -1) vend = clen;
			return decodeURIComponent(dcookie.substring(vbegin, vend));
		}
		cbegin = dcookie.indexOf(" ", cbegin) + 1;
		if (cbegin == 0) break;
	}
	return def;
} 


function logout(){
	if(confirm('로그아웃 하시겠습니까?')){
		setCookie('rose_user_login_id', '');
		setCookie('rose_user_login_pw', '');
		setCookie('rose_user_no','');
		location.replace('index');	
	}
}    

var rose_user_login_callbacks = {
	onsuccess: function(o){
		setCookie('rose_username', o.username);
		setCookie('rose_user_no', o.no);
		$('#user').html(getCookie('rose_user_login_id','') +' 님');
	},
	onfail: function(){
	},
}

$(function(){	
	/*
	var islogin = false;
	
	function rose_user_login_dologin(o, cb)
	{	
		var pw = hex_mysql(o.pw);
		이건 일단... pw 그대로 넘기자.. 
	
		var pw = o.pw;
		var id = o.id;

		$.post('logincheck', {
			id: id,
			pw: pw,
			url: o.url,
		}, function(s){
			console.log('LOGIN RESULT: ' + s);
			var result = false;
			try {
				var o = JSON.parse(s);
				console.log(o);
				if (o.success) {
					result = true;
					rose_user_login_callbacks.onsuccess(o);
				} else 
					throw s;
			}catch(e){
				console.log('ERROR: ' + e + s);
				//alert('로그인실패!');
				rose_user_login_callbacks.onfail();
			}
			cb(result);
		});	
	}

	var rose_user_login_html = "\
		<div id=rose_user_login-veil  >\
			<div id=box style='width: 300px; margin: 0 auto; text-align:left; margin-top:15%;'>\
				<center><h3>ROSE user</h3></center>\
				<label class='rose_user_login-label'>사용자명(이메일)</label>\
				<input id=rose_user_login-id value='<%-id%>' class='form-control'/>\
				<label class='rose_user_login-label''>비밀번호</label>\
				<input id=rose_user_login-pw type=password  xvalue='<%-pw%>' class='form-control' />\
				<br>\
				<center>\
				<input type=button class='btn btn-rose_user_login btn-primary'  value='로그인' style='width: 30%;' />\
				<input type=button class='btn btn-rose_user_register btn-outline-dark'  value='회원가입' style='width: 30%;' />\
				</center>\
				</div>\
			</div>\
		</div>\
	";


	var rose_user_login_compiled = _.template(rose_user_login_html);

	function rose_user_login_loadfromcookie()
	{
		var p = { 
			id: getCookie('rose_user_login_id', ''),
			pw: getCookie('rose_user_login_pw', ''),
			url: location.href,
		};
		console.log(p);
		return p;
	}

	function rose_user_login_cbdologin(success)
	{
		if (success) {
			islogin = true;
			$('#rose_user_login-veil').remove();
			return;
		}
		
		var $veil = $('#rose_user_login-veil');
		
		if ($veil.length == 0) {
			var html = rose_user_login_compiled(rose_user_login_loadfromcookie());
			$veil = $(html);
		}
		
		function setCookie(name,value){
			function parseUri (str) {
				var	o   = parseUri.options,
					m   = o.parser[o.strictMode ? "strict" : "loose"].exec(str),
					uri = {},
					i   = 14;

				while (i--) uri[o.key[i]] = m[i] || "";

				uri[o.q.name] = {};
				uri[o.key[12]].replace(o.q.parser, function ($0, $1, $2) {
					if ($1) uri[o.q.name][$1] = $2;
				});

				return uri;
			}
			parseUri.options = {
				strictMode: false,
				key: ["source","protocol","authority","userInfo","user","pw","host","port","relative","path","directory","file","query","anchor"],
				q:   {
					name:   "queryKey",
					parser: /(?:^|&)([^&=]*)=?([^&]*)/g
				},
				parser: {
					strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
					loose:  /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
				}
			};
			
			function getrootpath(url)
			{
					var path = '/';
					var dir = parseUri(url).directory.substring(1);
					var n = dir.indexOf('/');
					if (n > 0)
						path += dir.substring(0, n+1);
					return path;
			}
			
			var argc = setCookie.arguments.length;
			var argv = setCookie.arguments;

			var expires = ( argc > 2) ? argv[2]: 365;//null;
			var path = ( argc > 3) ? argv[3]:getrootpath(document.URL);//'/' null;
			var domain = ( argc > 4) ? argv[4]:null;
			var secure = ( argc > 5) ? argv[5]:false;
			
			if (typeof expires === 'number') 
			{
				var days = expires, t = expires = new Date();
				t.setDate(t.getDate() + days);
			}

			document.cookie = encodeURIComponent(name) + "=" + encodeURIComponent(value) +
				((expires == null) ? "" : ("; expires =" + expires.toUTCString())) +
				((path == null) ? "" : ("; path =" + path)) +
				((domain == null) ? "" : ("; domain =" + domain)) +
				((domain == true) ? "; secure" : "");
		}	

		$veil.appendTo('html');
		
		$('.btn-rose_user_login').click(function(){
			var id = $('#rose_user_login-id').val();
			setCookie('rose_user_login_id', id);
			setCookie('rose_user_login_pw', $('#rose_user_login-pw').val());
			rose_user_login_dologin(rose_user_login_loadfromcookie(), rose_user_login_cbdologin);			
		});
		$('.btn-rose_user_register').click(function(){
			location.href = 'register';	
		});		
	}
	
	var hTimer = setInterval(function(){
		if(islogin) {
			clearTimeout(hTimer);
			return;
		}
			
		if ($('#rose_user_login-veil').length == 0) {
			rose_user_login_dologin(rose_user_login_loadfromcookie(), rose_user_login_cbdologin);
		}
		var maxz = 1;
		$('body,div').each(function(){

			var z = parseInt($(this).css('z-index'));
			if (isNaN(z)) 
				return;
			if(z > maxz)
				maxz = z*1;
		});
		// 베일 복구 &
		//z-index변경 막기
		
		if (maxz <= $('#rose_user_login-veil').css('z-index'))
			maxz = $('#rose_user_login-veil').css('z-index');
		else
			maxz++;
	
		$('#rose_user_login-veil').attr('style', 'padding: 10px; \
			color: black;\
			position: fixed !important; width: 100% !important; height: 100% !important; left: 0 !important; top: 0 !important;\
			background-color: #efefef; text-align: center; \
			line-height: 1.5em;\
			z-index: '+maxz+' !important;'
		);
	}, 100);
		*/
});
