var TreeEditor = Backbone.View.extend({
	el: 'body',
	tree: new Tree(),
	events: {
		'click .node-add-btn': 'nodeaddbtnclick',
		'click .node-del-btn': 'nodedelbtnclick',
		'click .leaf-name': 'leafclick',
		'click .save-btn': 'savebtnclick',
		'click .load-btn': 'loadbtnclick',
		'click .export-json-btn': 'exportjsonbtnclick',
		'click .export-pair-btn': 'exportpairbtnclick',
		'change .property': 'propertychange',
		'dblclick .leaf-name': 'leafnamedblclick',
		'dblclick .key-name': 'keynamedblclick',
		'blur input[name="leaf-name"]': 'leafnameblur',
		'blur input.key': 'propkeyblur',
		//'blur input.property
		'change input[name="leaf-name"]': 'leafnamechange',
		'click .prop-del-btn': 'propertychange',
		'click .prop-add-btn': 'propaddclick',
		'change .node-memo': 'nodememochange',
		'click .expand-btn': 'expandbtnclick',
	},
	expandbtnclick: function(e){
		var $el = $(e.currentTarget);	
		var $node = $el.closest('.node'); 
		var path = $node.attr('path');
		var node = this.tree.find(path);
		node.expanded = !node.expanded;
		//$node.empty();
		this._render(node, $node.parent());
	},
	nodememochange: function(e){
		var $el = $(e.currentTarget);	
		var path = this.$('#prop-view').attr('path');
		var node = this.tree.find(path);
		node.memo = $el.val();		
	},
	propmemochange: function(e){
		var $el = $(e.currentTarget);	
		var path = this.$('#prop-view').attr('path');
		var node = this.tree.find(path);
		node.memo = $el.val();
	},
	propaddclick: function(e){
		var $el = $(e.currentTarget);	
		var path = $el.closest("[path]").attr('path');
		var node = this.tree.find(path);		
		node.values.push({
			k: 'new prop '+ (node.values.length+1),
			v: null,
			type: 'string',
		});
		var $leaf = this.$('.leaf.focused');
		this.renderPropView($leaf);
		this._render(node, $leaf.parent());
		this.$('.node[path="'+path+'"]').addClass('focused');
	},
	nodeaddbtnclick: function(e){
		e.stopPropagation();			
		var $node = $(e.currentTarget).closest('[path]');
		var path = $node.attr('path');
		var node = this.tree.find(path);
		var child = this.tree.newChild(node);
		var $leaf = this.$('.leaf.focused');
		this.renderPropView($leaf);
		this._render(node, $leaf.parent());
		this.$('.node[path="'+path+'"]').addClass('focused');
	},
	leafnamechange: function(e){
		var $el = $(e.currentTarget);
		var $leaf = $(e.currentTarget).closest('.leaf');
		var $node = $(e.currentTarget).closest('.node');
		var node = this.tree.find($node.attr('path'));
		var $newLeaf;
		if ($leaf.hasClass('node')) {
			node.name = $el.val();
			$newLeaf = this.renderNode(node);
			$leaf.replaceWith($newLeaf);
			
			this._render(node, $newLeaf.parent());
			//$newLeaf = this.$('.node [path="'+node.getPath()+'"]');
		} else {
			var v = node.findValue($leaf.attr('key'));
			v.k = $el.val();
			$newLeaf = this.renderPropLeaf(v, $leaf.attr('path'));
			$leaf.replaceWith($newLeaf);
		}
		this.renderPropView($newLeaf);
	},
	leafnameblur: function(e){		
		var $el = $(e.currentTarget);
		var $node = $(e.currentTarget).closest('.leaf');
		$node.removeClass('editing');
	},
	propkeyblur: function(e){		
		var $el = $(e.currentTarget);
		var $editor = $(e.currentTarget).closest('.property-editor');
		$editor.removeClass('editing');
	},
	leafnamedblclick: function(e){
		var $el = $(e.currentTarget);
		var $node = $(e.currentTarget).closest('.leaf');
		$node.toggleClass('editing');
		$node.find('input').focus();
	},
	keynamedblclick: function(e){
		//console.
	
		var $el = $(e.currentTarget);
		var $prop = $(e.currentTarget).closest('.property-editor');
		$prop.toggleClass('editing');
		$el.parent().find('input').focus();
	},
	propertychange: function(e){
		var $el = $(e.currentTarget);	
		var path = this.$('#prop-view').attr('path');
		var node = this.tree.find(path);
		console.log('prop change', path, node);
		var $editor = $el.closest('.property-editor');
		var key = $editor.attr('key');
		//console.log(el.defaultValue);
		for(var i in node.values) {
			var c = node.values[i];
			if (c.k == key) {
				break;
			}
		}
		if ($el.hasClass('key'))
			c.k = $el.val();
		if ($el.hasClass('value'))
			c.v = $el.val();
		if ($el.hasClass('type'))
			c.type = $el.val();
		if ($el.hasClass('memo'))
			c.memo = $el.val();
		if ($el.hasClass('prop-del-btn'))
		{
			if (!confirm(node.values[i].k + ' 속성을 삭제합니다.'))
				return;
			delete node.values[i];
			node.values.splice(i, 1);
			$editor.empty();
			this.render(this.tree.root);
			//this.$('.leaf
			//alert('del');
			return;
		}		
		var $newLeaf = this.renderPropLeaf(c, path);
		var $leaf = this.$('[key="%0"][path="%1"]'.format2(key, path));
		$leaf.replaceWith($newLeaf);
		if ($el.hasClass('key')){ //property name이 변경되었을때만
			if ($el.closest('.summary').length == 0)
				$editor.replaceWith(this.renderPropEditor(node, c));
			else {
				$editor.replaceWith(this.summaryPropTemplate(c));
			}
		}
	},	
	renderPropEditor: function(node, property)
	{		
		property.__fullName = node.getPath() + property.k;
		var $newEditor = $(this.propEditorTemplate(property));
		return $newEditor;
	},
	exportjsonbtnclick: function(e){
		var obj = this.tree.buildResult();
		console.log(JSON.stringify(obj));
		//localStorage.lastTree = json;
	},
	exportpairbtnclick: function(e){
		var obj = this.tree.buildPairObj();
		console.log(obj);
		return obj;
		//var obj = this.tree.buildResult();
		//console.log(JSON.stringify(obj));
		//localStorage.lastTree = json;
	},
	save: function(){
		var json = this.tree.buildJson();
		console.log(json);
		//localStorage.lastTree = json;
		$.post("api/save", {
			treedata: json, 			
		}, function(s){
			console.log(s);
		});
	},
	savebtnclick: function(e){
		this.save();
	},
	loadbtnclick: function(e){
		this.load();
	},	
	renderPropView: function($leaf){
		//var $node = $(e.currentTarget).closest('.leaf');
		var path = $leaf.attr('path');
		var node = this.tree.find(path);
		var $editor;
		if ($leaf.hasClass('node'))
		{
			node.__fullName = $leaf.attr('path');
			$editor = this.nodeEditorTemplate(node);
			this.$('#prop-view').html($editor).attr('path', path);
			for(i in node.values) {
				//console.log(node.values[i]);
				var html = this.summaryPropTemplate(node.values[i]);
				//console.log(html);
				this.$('.prop-table tbody').append(html);
			}
			for(i in node.children) {
				//console.log(node.values[i]);
				var html = this.summaryNodeTemplate(node.children[i]);
				//this.$('.node-table tbody').append(html);
				this.$('#children-pool').append(html);
			}
			
		} else
		{
			var key = $leaf.attr('key');
			console.log(node, key);
			var c = node.findValue(key);
			console.log(key, c);
			c.__fullName = $leaf.attr('path') + c.k;
			$editor = this.propEditorTemplate(c);
			this.$('#prop-view').html($editor).attr('path', path);
		}
	},
	
	leafclick: function(e){
		this.$('.focused').removeClass('focused');
		var $leaf = $(e.currentTarget).closest('.leaf');
		$leaf.addClass('focused');
		
		this.renderPropView($leaf);		
	},
	nodedelbtnclick: function(e){
		e.stopPropagation();
		
		var $node = $(e.currentTarget).closest('[path]');
		var node = this.tree.find($node.attr('path'));
		if (node.children.length > 0) {
			alert('하위 노드가 있는 노드는 삭제 불가');
			return;
		}
		if (!confirm(node.getPath() + ' 키를 삭제합니다'))
			return;
		this.tree.deleteChild(node);
		this.render(this.tree.root);
		this.$('#prop-view').empty();
	},
	renderNode: function(node) {
		var $node = $(this.nodeTemplate(node));
		$node.attr('path', node.getPath());
		return $node;
	},
	clearPathNode: function(path){
		this.$('#tree [path="'+path+'"]').empty();		
	},
	renderPropLeaf: function(leaf, path)
	{
		var $leaf = $(this.propLeafTemplate(leaf));
		$leaf.attr({
			path: path,
			'full-name': path + leaf.k,
		});
		return $leaf;			
	},
	_render: function(node, $nodeContainer){
		if ($nodeContainer == null)
			$nodeContainer = this.$('#tree');
		var path = node.getPath();		
		var $node = this.renderNode(node);
		$node.attr('path', path);
		// this.$('#tree [path="'+path+'"]').empty();
		var $el = $nodeContainer.find('.node[path="'+path+'"]');
		if ($el.length > 0) {
			$el.replaceWith($node);
			console.log('replace');
		} else
			$nodeContainer.append($node);
		
		//$nodeContainer.append($node);
		if (node.expanded)  {
			for(var i in node.values)
			{
				var c = node.values[i];
				c.depth = node.depth+1;
				var $leaf = this.renderPropLeaf(c, path);
				$node.append($leaf);
			}		
			for(var i in node.children)
			{
				var c = node.children[i];
				
				//this.$('#tree [path="'+c.getPath()+'"]').empty();
				//this.clearPathNode(c.getPath());
				//console.log(c.getPath());
				//if (node.expanded) 
				this._render(c, $node);
			}
		}
	},
	render: function(){
		this.$('#tree').empty();
		var node = this.tree.root;
		this._render(this.tree.root);
	},
	initialize: function(){
		this.nodeTemplate = _.template($('#node-template').html());
		this.summaryPropTemplate = _.template($('#summary-prop-template').html());
		this.summaryNodeTemplate = _.template($('#summary-node-template').html());
		this.propLeafTemplate = _.template($('#prop-leaf-template').html());
		this.propEditorTemplate = _.template($('#prop-edit-template').html());
		this.nodeEditorTemplate = _.template($('#node-edit-template').html());
		/*
		try {
			this.tree.loadJson(localStorage.lastTree);
		}catch(e){
			console.log(e);
		}*/
		this.render();
	},
	load: function(){
		var me = this;
		$.post("api/load", {
		}, function(o){
			console.log(o);
			me.tree.loadJson(o, true);
			me.render();
			me.$('.node[path="/"]>.leaf-name').trigger('click');//();//addClass('focused');
		}, 'json').fail(function(e){
			console.log(e.responseText);
			console.log(e);
		});
	}	
});
