# JsPhpize
[![Latest Stable Version](https://poser.pugx.org/js-phpize/js-phpize/v/stable.png)](https://packagist.org/packages/js-phpize/js-phpize)
[![Build Status](https://travis-ci.org/pug-php/js-phpize.svg?branch=master)](https://travis-ci.org/pug-php/js-phpize)
[![StyleCI](https://styleci.io/repos/65670436/shield?style=flat)](https://styleci.io/repos/65670436)
[![Test Coverage](https://codecov.io/gh/pug-php/js-phpize/branch/master/graph/badge.svg)](https://codecov.io/gh/pug-php/js-phpize)
[![Code Climate](https://codeclimate.com/github/pug-php/js-phpize/badges/gpa.svg)](https://codeclimate.com/github/pug-php/js-phpize)

Convert js-like syntax to standalone PHP code.

## Install
In the root directory of your project, open a terminal and enter:
```shell
composer require js-phpize/js-phpize
```

## Usage
Use compile to get PHP equivalent code to JavaScript input:
```php
use JsPhpize\JsPhpize;

$jsPhpize = new JsPhpize();

echo $jsPhpize->compile('foo = { bar: { "baz": "hello" } }');
```

This code will output the following PHP code:
```php
$foo = array( "bar" => array( "baz" => "hello" ) );
```

Or use render to execute it directly:
```php
use JsPhpize\JsPhpize;

$jsPhpize = new JsPhpize();

$code = '
    // Create an object
    foo = { bar: { "baz": "hello" } };
    key = 'bar'; // instanciate a string

    return foo[key].baz;
';

$value = $jsPhpize->render($code);

echo $value;
```

This will display ```hello```.

This library intend to is intended to allow js-like in PHP contexts (such as in template engines).

See the [Phug documentation](https://www.phug-lang.com/#js-style-expressions)
to see an implementation example as Pug expressions PHP converter.

And also check [examples](https://github.com/pug-php/js-phpize/tree/master/examples)
to see more examples (**.js** files are input examples **js-phpize** can handle
and either **.return** show you what the engine will return for this code,
or **.php** show you how it's compiled into PHP).
