<?php

//utf8유지용한글
//include_once('/lib/pdodb.php');
include_once('pdodb.php');

function dieJSON($s)
{
	die(json_encode($s));
}

function replyJSON($s)
{
	echo json_encode($s); 
//	die();
}

function reply_json($s)
{
	replyJSON($s);
}
function json_reply($s)
{
	replyJSON($s);
}
function now($sec=0)
{
	return date('Y-m-d H:i:s', time() + $sec);
}

function redirect($url)
{
	Header( "HTTP/1.1 301 Moved Permanently" );
	Header( "Location: $url");
	die();
}

function query($q, $func)
{
	if (!$func)
		throw "query needs callback";
	
	$db = pdo2();
	return $db->query($q, $func);
}

function query_deprecated($q, $f=null)
{
	try {
		$db = pdo();
		if (!$f)
			return $db->query($q);
		
		$row = $db->query($q);
		foreach($row as $r)
			$f($r);
	} catch (Exception $e) {
		//echo "$q\n";
		throw $e;
	}
}

function execsql_deprecated($q, $f = null)
{
	$db = pdo();
	if (!$f)
		return $db->exec($q);
	$db->exec($q);
	$f($db);
}

function query2_deprecated($q)
{
	$db = pdo();
	$db->query($q);
	return $db;
}

function execsql2_deprecated($q, &$result=-1)
{
	$db = pdo();
	$r = $db->exec($q);
	if ($result != -1)
		$result = $r;
	return $db;
}

function cleanphoneno($val)
{
	return str_replace("-", "", $val);
}

function cleantel($val)
{
	return cleanphoneno($val);
}

function qrcode($url = 'http://google.com', $w=190, $h=190)
{
	return "<img src=http://chart.apis.google.com/chart?cht=qr&chs=$w"."x$h&chld=L|1&chl=$url>";	
}

function cookie_unset()
{
	if (isset($_SERVER['HTTP_COOKIE'])) {
		$cookies = explode(';', $_SERVER['HTTP_COOKIE']);
		foreach($cookies as $cookie) {
			$parts = explode('=', $cookie);
			$name = trim($parts[0]);
			setcookie($name, '', time()-1000);
			setcookie($name, '', time()-1000, '/');
		}
	}
}

function setcookie2($key, $val, $expiry = null)
{
	$key = urlencode($key);
	
	if ($expiry == null)
		$expiry = time() + 60*60*24*365; // 기본 1년
		
	//echo $_SERVER[HTTP_HOST];
	$uri = substr($_SERVER[REQUEST_URI], 1);
	//echo $uri;
	$n = strpos($uri, '/');
	//echo $n;
	if ($n === false)
		$cookiepath = '/';
	else
		$cookiepath = '/'.strstr($uri, '/', true).'/'; 
		
//	echo $cookiepath;
		
	setcookie($key, $val, $expiry, $cookiepath);
}

function get_url_no()
{
		$strip =  basename($_SERVER['REQUEST_URI']);
		$strip = explode( "?", $strip );

		if( count($strip) > 0 )
		{
			if ($strip[0]*1 == 0)
				return null;
			return $strip[0];
		}

		return NULL;
}

function fetchall($ctx)
{
	$r = [];
	foreach($ctx as $row){
		array_push($r, $row);
	}	
	return $r;
}

?><?php  

  /* * File: SimpleImage.php * Author: Simon Jarvis * Copyright: 2006 Simon Jarvis * Date: 08/11/06 * Link: http://www.white-hat-web-design.co.uk/articles/php-image-resizing.php * * This program is free software; you can redistribute it and/or * modify it under the terms of the GNU General Public License * as published by the Free Software Foundation; either version 2 * of the License, or (at your option) any later version. * * This program is distributed in the hope that it will be useful, * but WITHOUT ANY WARRANTY; without even the implied warranty of * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the * GNU General Public License for more details: * http://www.gnu.org/licenses/gpl.html * */  

//  - See more at: http://www.white-hat-web-design.co.uk/blog/resizing-images-with-php/#sthash.f5crC08u.dpuf
  
class SimpleImage {
	var $image;
	var $image_type;
	function load($filename) {
		$image_info = getimagesize($filename);
		$this->image_type = $image_info[2];
		if($this->image_type==IMAGETYPE_JPEG) {
			$this->image = imagecreatefromjpeg($filename);
		}
		elseif($this->image_type==IMAGETYPE_GIF) {
			$this->image = imagecreatefromgif($filename);
		}
		elseif($this->image_type==IMAGETYPE_PNG) {
			$this->image = imagecreatefrompng($filename);
		}
	}
	function save($filename,$image_type = IMAGETYPE_JPEG,$compression = 75,$permissions = null) {
		if($image_type==IMAGETYPE_JPEG) {
			imagejpeg($this->image,$filename,$compression);
		}
		elseif($image_type==IMAGETYPE_GIF) {
			imagegif($this->image,$filename);
		}
		elseif($image_type==IMAGETYPE_PNG) {
			imagepng($this->image,$filename);
		}
		if($permissions!=null) {
			chmod($filename,$permissions);
		}
	}
	function output($image_type = IMAGETYPE_JPEG) {
		if($image_type==IMAGETYPE_JPEG) {
			imagejpeg($this->image);
		}
		elseif($image_type==IMAGETYPE_GIF) {
			imagegif($this->image);
		}
		elseif($image_type==IMAGETYPE_PNG) {
			imagepng($this->image);
		}
	}
	function getWidth() {
		return imagesx($this->image);
	}
	function getHeight() {
		return imagesy($this->image);
	}
	function resizeToHeight($height) {
		$ratio = $height/$this->getHeight();
		$width = $this->getWidth()*$ratio;
		$this->resize($width,$height);
	}
	function resizeToWidth($width) {
		$ratio = $width/$this->getWidth();
		$height = $this->getheight()*$ratio;
		$this->resize($width,$height);
	}
	function scale($scale) {
		$width = $this->getWidth()*$scale/100;
		$height = $this->getheight()*$scale/100;
		$this->resize($width,$height);
	}
	function resize($width,$height) {
		$new_image = imagecreatetruecolor($width,$height);
		imagecopyresampled($new_image,$this->image,0,0,0,0,$width,$height,$this->getWidth(),$this->getHeight());
		$this->image = $new_image;
	}
}?>