<?php

include_once("libgods.php");

function writeln($s)
{
	print $s."\n";
}

interface iGoGridCallback
{
	function onfetch(&$row);
}

class GoGrid
{
	var $tableid;
	var $query;
	var $cols = null;
	var $callback = null;
	function setcallback($cb)
	{
		$this->callback = $cb;
	}
	
	function setquery($q)
	{
		$this->query = $q;
	}

	function __construct($id = null)
	{
		if ($id == null)
			$this->tableid = get_class($this);
		else
			$this->tableid = $id;
	}
	
	function renderheader($r)
	{
		writeln("<tr>");
		if ($this->cols == null)
		{
			foreach($r as $key=>$val)
			{
				writeln("<th>$key</th>");
			}
		}
		else
		{
			foreach($this->cols as $key=>$val)
			{
				writeln("<th>$val</th>");
			}
		}
		writeln("</tr>");
	}
	
	function formatcol($key, $val)
	{
		return "$val";
	}
	
	function cellattr($key, $no, $val)
	{
		return "id='td_$key$no' class=td_$key name='$key' value='$val'";
	}
	
	function renderrow($r)
	{
		writeln("<tr recno='$r[no]' >");
		
		if ($this->cols == null)
		{
			foreach($r as $key=>$val)
			{
				$v = $this->formatcol($key, $val);
				$attr = $this->cellattr($key, $r[no], $r[$key]);
				writeln("<td $attr >$v</td>");
				
			}
		} else
		{
			foreach($this->cols as $key=>$val)
			{
				if (gettype($key) == 'integer')
					$key = $val;
				//echo $key.$val.'<br />';
				$v = $this->formatcol($key, $r[$key]);
				$attr = $this->cellattr($key, $r[no], $r[$key]);
				writeln("<td $attr >$v</td>");
			}
		}
		writeln("</tr>");
	}
	
	function render()
	{
		$id = $this->tableid;
		writeln("
<style>
.gogrid
{
	margin-left: auto;
	margin-right: auto;
	border: 1px solid #bbb;
	border-collapse: collapse;
}

.gogrid td, .gogrid th
{
	border: 1px solid #bbb;
	padding: 4px 8px 4px 8px;
	text-align: center;
}
</style>		
		
		");
		writeln("<table id='$id' class='gogrid'>");
		
		$list = query($this->query);
		$list->setFetchMode(PDO::FETCH_ASSOC);

		$first = true;
		foreach($list as $row)
		{
			if ($this->callback != null)
				$this->callback->onfetch($row);
				
			if ($first)
			{
				$this->renderheader($row);
				$first = false;
			}			
			$this->renderrow($row);
		}		
		writeln("</table>");
	}
	
	function setCols($cols)
	{
		$this->cols = $cols;
	}
}

/*

class KioskGrid extends GoGrid
{
	function formatcol($key, $val)
	{
		switch ($key)
		{
		case "ȭȣ": 
			return str_replace("-", "", $val);
			break;
		default:  return $val;
		}
	}
}


class KioskSummary extends Controller {
	var $string;
	var $list;
	var $r; 
	var $grid;
	function Login() {
		$this->result_uri	= 'franchise/KioskSummaryLogin.htm';
		$this->dispatcher();
	}
	
	function Show() {
	//ID : family01, PW : cvs999
		if ($_REQUEST[id] != 'family01' || $_REQUEST[pw] != 'cvs999')
		{
			redirect('Login');
			return;
		}
		
		
		$q = "
		select * 
		from Աݷα a, account b 
		where 
			a.accountno = b.no 
			and ȭȣ <> '010-3333-4422'
			and ȭȣ <> '010-3333-4444'
			and ȭȣ <> '010-5383-0573'
		order by Աݽð desc";
		//$r = query();
		//$this->list = $r;
		$this->grid = new KioskGrid();
		$this->grid->setquery($q);
		$this->grid->setcols(array('Աݽð', 'Աݾ', 'ȭȣ'=>''));
		
		$this->result_uri	= 'franchise/KioskSummary.htm';
		$this->dispatcher();
	}
}

*/
?>