<?
function httpPostCacheable($url, $post, $cachevalidtime, $timeout = 5)
{
	$dir = "/tmp/cmsquery/";
	$old = umask(0);
	@mkdir($dir, 0777, true);
	umask($old);
	
	$fn = $dir.md5($url.json_encode($post)).'.post';
	//die($fn);
	
	if (file_exists($fn)) {
		$time = filemtime($fn);
		$now = time();
		$elapsed = $now - $time;
		if ($elapsed < $cachevalidtime)
		{
			error_log("reading Post $url from $fn");
			$response = file_get_contents($fn);
			if ($response !== false)
			{
				return $response;
			}
			die('error');
		}		
		// 캐쉬파일이 존재하는 경우, 동시에 httpget을 요청하는 클라이언트에는 그냥 원래 있던 캐쉬를 돌려주기 위해 시간을 현재로 바꾼다.
		touch($fn);
	}
	
	$ch = curl_init($url);		
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, $timeout); 
	$response = curl_exec($ch);
	curl_close($ch);
	
	file_put_contents($fn, $response, LOCK_EX);
	return $response;
}

function httpGet($url, $params=null, $timeout = 10)
{
	return httpGetCacheable($url, $params, 0, $timeout);
}

function httpPost($url, $post, $timeout = 10)
{
	return httpPostCacheable($url, $post, 0, $timeout);
}

function httpGetCacheable($url, $params, $cachevalidtime, $timeout = 10) 
/**
httpget 자체 캐쉬로 동작하는 httpget
validtime = 캐쉬유효시간
timeout = http timeout, 기본5초
*/
{
	$dir = "/tmp/cmsquery/";
	$old = umask(0);
	@mkdir($dir, 0777, true);
	umask($old);
	
	if ($params) {
		if (strpos($url, "?") ===false)
			$url .= "?";
		$url .= http_build_query($params);
	}
	
	//$fn = $dir.urlencode($url);
	$fn = $dir.md5(urlencode($url)).'.get';
	//$fn = $dir.md5($url.json_encode($post)).'.post';	
	
	if (file_exists($fn)) {
		$time = filemtime($fn);
		$now = time();
		$elapsed = $now - $time;
		if ($elapsed < $cachevalidtime)
		{
			error_log("reading Get $url from $fn");
			$response = file_get_contents($fn);
			if ($response !== false)
			{
				return $response;
			}
			die('error');
		} 
		
		// 캐쉬파일이 존재하는 경우, 동시에 httpget을 요청하는 클라이언트에는 그냥 원래 있던 캐쉬를 돌려주기 위해 시간을 현재로 바꾼다.
		touch($fn);
	}

	//$response = file_get_contents($url);
	
	$context = stream_context_create(array(
		'http' => array(
			'timeout' => $timeout
		) 
	)); 	
	$response = @file_get_contents($url, 0, $context);
	if (!$response) {
		error_log($url."reading error");
		return;
	}
	file_put_contents($fn, $response, LOCK_EX);
	return $response;
}

	
?>
