<?
	include_once("config.php");
	class Device extends Fly5 {
		function fetchRepeats($a)
		{
			//echo "diet fetch";
			$a[hid] = 'IM39';
			$seq = query("
				select * from 
					diet
					left join meal on diet.no=dietno
					where 
						diet.name=:dietname and hid=:hid and isnull(date)
					order by
						seq", $a);
			$firstdate = date_create("2001-01-01");
			$date = $a[date];
			if(!$date)
				$date = date("Y-m-d");
			$date = date_create($date);
			$days = $date->diff($firstdate)->days;
			
			$result = array();
			for($i = 0; $i < 3; $i++) {
				$t = $seq[($days+$i)%count($seq)];
				$t[date] = $date->format("Y-m-d");
				$t[seq] = $i+1;
				unset($t[creationtime]);
				$date->add(new DateInterval('P1D'));
				array_push($result, $t);
			}
			return $result;
		}
		
		function execute(&$view, $path, $args)
		{
			$a = $_REQUEST;
			switch($path) {
			case "Device/api/fetchDevices":
				$result = $this->fetchDevices($_REQUEST[hid]);
				break;
			case "Device/api/searchDevices":
				$result = $this->fetchDevices($a);
				break;
			case "Device/api/createDevice":
				$result = $this->createDevice($a);
				break;
			case "Device/api/updateDevice":
				$result = $this->updateDevice($a);
				break;
			case "Device/api/deleteDevice":
				$result = $this->deleteDevice($a);
				break;   
			case "Device/api/searchDevice":
				$result = $this->searchDevice($a);
				break;   
			default:
				$view = "$path.pug";
				return;
			}
			reply_json($result);
		}
		function fetchDevices($hid)
		{
			$rows = query("select * from uis.terminal where 서비스코드=:hid order by creationtime desc", array(hid=>$hid));
			if($hid ==='병원코드'){
				$rows = query("select * from uis.terminal order by creationtime desc");
			}
			return $rows;
		}
		function searchDevice($a)
		{
			$rows = query("select * from uis.terminal where 서비스코드=:hid order by creationtime desc", $a);
			if($a[hid]==='병원코드'){
				$rows = query("select * from uis.terminal order by creationtime desc", $a);
				if($a[searchField]!=='전체'){
					switch( $a[searchField] )
					{	
						case '층' :
							$rows = query("select * from uis.terminal where floor=:searchKey", $a);
							break;
						case '병상': 
							$rows = query("select * from uis.terminal where bedno=:searchKey", $a);
							break;
						case '병실': 
							$rows = query("select * from uis.terminal where room=:searchKey", $a);
							break;
						case 'MAC': 
							$rows = query("select * from uis.terminal where mac=:searchKey", $a);
							break;
					}
				}

			}else{
				switch( $a[searchField] )
				{	
					case '층' :
						$rows = query("select * from uis.terminal where 서비스코드=:hid AND floor=:searchKey", $a);
						break;
					case '병상': 
						$rows = query("select * from uis.terminal where 서비스코드=:hid AND bedno=:searchKey", $a);
						break;
					case '병실': 
						$rows = query("select * from uis.terminal where 서비스코드=:hid AND room=:searchKey", $a);
						break;
					case 'MAC': 
						$rows = query("select * from uis.terminal where 서비스코드=:hid AND mac=:searchKey", $a);
						break;
				}	
			}
			return $rows;
		}
		function createDevice($a){
			$rows = query("insert into uis.terminal(mac,floor,서비스코드,room,bedno,ip) values(:mac,:floor,:hid,:room,:bedno,:ip)", $a);
			return $rows;
		}
		function updateDevice($a){
			$rows = query("update uis.terminal set mac=:mac, ip=:ip, room=:room, bedno=:bedno, floor=:floor, 서비스코드=:hid where no=:no", $a);
		}
		function deleteDevice($a){
			$rows = query("delete from uis.terminal where no=:no",$a);
			return $rows;
		}
		function main(&$view)
		{
			$view = 'Device/main.pug';
			return array(
				devices=>$this->fetchDevices('IM39'),
			);
		}
		function mainProto(&$view) 
		{
			$view = "Device/main-proto.pug";
			return $this->main($view);
		}
	}
?>